/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.client.tileentityrenderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.zkryle.jeg.client.events.StaticClientEventSubscriber;
import com.zkryle.jeg.common.tileentities.ChargingTableBlockEntity;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ChargingTableBlockEntityRenderer
implements BlockEntityRenderer<ChargingTableBlockEntity> {
    public ChargingTableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ChargingTableBlockEntity pBlockEntity, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        if (pBlockEntity.hasCore()) {
            Minecraft mc = Minecraft.func_71410_x();
            pMatrixStack.pushPose();
            pMatrixStack.translate(0.5, 0.5, 0.5);
            pMatrixStack.mulPose(Vector3f.YP.rotationDegrees((float)pBlockEntity.getRotationAnim()));
            pMatrixStack.translate(-0.5, -0.5, -0.5);
            pMatrixStack.mulPose(Vector3f.XN.rotationDegrees(90.0f));
            pMatrixStack.translate((double)-0.03f, (double)-1.03f, (double)0.37f);
            pMatrixStack.scale(1.0f, 1.0f, 1.0f);
            RenderType renderType = ItemBlockRenderTypes.getRenderType((BlockState)mc.field_71441_e.getBlockState(pBlockEntity.getBlockPos()), (boolean)false);
            pMatrixStack.translate(0.0, 0.0, (double)(pBlockEntity.getCorePercentage() / 100.0f - 0.01f));
            mc.getBlockRenderer().getModelRenderer().renderModel(pMatrixStack.last(), pBuffer.getBuffer(renderType), mc.field_71441_e.getBlockState(pBlockEntity.getBlockPos()), this.getCoreModel(pBlockEntity), 1.0f, 1.0f, 1.0f, pCombinedLight, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            pMatrixStack.popPose();
            if (pBlockEntity.getCore().getDamageValue() == 0) {
                this.renderParticleSpiral(pBlockEntity);
            }
        }
    }

    private BakedModel getCoreModel(ChargingTableBlockEntity pBlockEntity) {
        Minecraft mc = Minecraft.func_71410_x();
        short charge = pBlockEntity.getCharge();
        BakedModel coreModel = mc.getModelManager().getModel((ResourceLocation)StaticClientEventSubscriber.RECHARGING_CORE);
        BakedModel fullCoreModel = mc.getModelManager().getModel((ResourceLocation)StaticClientEventSubscriber.FULL_CORE);
        if (charge > 0 && pBlockEntity.getCorePercentage() < 100.0f) {
            return coreModel;
        }
        if (pBlockEntity.getCorePercentage() <= 75.0f) {
            return mc.getItemRenderer().getModel(pBlockEntity.getCore(), (Level)mc.field_71441_e, (LivingEntity)mc.field_71439_g, 0);
        }
        return fullCoreModel;
    }

    private void renderParticleSpiral(BlockEntity pBlockEntity) {
        Minecraft mc = Minecraft.func_71410_x();
        double degrees = Math.toRadians(0.2);
        double end = 7200.0 * degrees;
        double a = 0.0;
        double b = 0.12;
        double c = 2.0;
        BlockPos pos = pBlockEntity.getBlockPos().above();
        for (double theta = 0.0; theta < end; theta += degrees) {
            double r = a + b * Math.pow(theta, 1.0 / c);
            double x = r * Math.cos(theta);
            double z = r * Math.sin(theta);
            if (new Random().nextInt(20000) != 9) continue;
            mc.field_71441_e.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, (double)((float)pos.getX() + 0.5f) + x, (double)pos.getY() + theta / 25.0, (double)((float)pos.getZ() + 0.5f) + z, 0.0, 0.0, 0.0);
        }
    }
}

